import os
import json
import subprocess
import webbrowser
import getpass

DATA_FILE = 'users.json'

def clear():
    os.system('cls' if os.name == 'nt' else 'clear')

def pause():
    input("\nPress Enter to continue...")

def load_users():
    if os.path.exists(DATA_FILE):
        with open(DATA_FILE, 'r') as f:
            return json.load(f)
    return {}

def save_users(users):
    with open(DATA_FILE, 'w') as f:
        json.dump(users, f, indent=4)

def print_border(title=""):
    border_line = "═" * 50
    print(f"╔{border_line}╗")
    if title:
        print(f"║{title.center(50)}║")
    print(f"╚{border_line}╝")

def print_header():
    clear()
    print_border("Triumphant OS")
    print()

def register_user(users):
    print_header()
    print("Register New User")
    username = input("Username: ").strip()
    if len(users) >= 1000000000000000000000000000000000000000000:
        print("Maximum user limit reached.")
        pause()
        return users
    if username in users:
        print("User already exists.")
        pause()
        return users
    password = input("Password: ").strip()
    users[username] = {"password": password, "settings": {}}
    save_users(users)
    print(f"User '{username}' registered successfully.")
    pause()
    return users

def login_user(users):
    print_header()
    print("Login")
    username = input("Username: ").strip()
    password = getpass.getpass("Password (input hidden): ").strip()

    while True:
        show_option = input("Would you like to view the entered password? (y/n): ").strip().lower()
        if show_option == 'y':
            print(f"Entered Password: {password}")
            break
        elif show_option == 'n':
            break
        else:
            print("Please enter 'y' or 'n'.")

    if username in users and users[username]['password'] == password:
        print(f"\nWelcome, {username}!")
        pause()
        user_session(users, username)
    else:
        print("Invalid username or password.")
        pause()

def user_session(users, username):
    while True:
        print_header()
        print(f"Logged in as: {username}")
        print("1. Command Prompt")
        print("2. Task Manager")
        print("3. Web Browser")
        print("4. Settings Menu")
        print("5. Search Settings")  # Added this menu option
        print("6. App Store")
        print("7. Reset Password")
        print("8. Update Username")
        print("9. Logout")
        choice = input("Select an option (1-9): ").strip()
        if choice == '1':
            command_prompt()
        elif choice == '2':
            task_manager()
        elif choice == '3':
            open_browser()
        elif choice == '4':
            settings_menu(users, username)
        elif choice == '5':
            search_settings(users, username)  # Call the new function
        elif choice == '6':
            app_store()
        elif choice == '7':
            reset_password(users, username)
        elif choice == '8':
            username = update_username(users, username)
        elif choice == '9':
            print("Logging out...")
            pause()
            break
        else:
            print("Invalid choice.")
            pause()

def update_username(users, current_username):
    new_username = input("Enter new username: ").strip()
    if new_username in users:
        print("Username already exists.")
        pause()
        return current_username
    users[new_username] = users.pop(current_username)
    save_users(users)
    print(f"Username changed to {new_username}.")
    pause()
    return new_username

def command_prompt():
    print_header()
    print("Command Prompt. Type 'exit' to return.")
    while True:
        cmd = input("C:\\> ").strip()
        if cmd.lower() == 'exit':
            break
        if cmd:
            try:
                output = subprocess.check_output(cmd, shell=True, universal_newlines=True, stderr=subprocess.STDOUT)
                print(output)
            except Exception as e:
                print(f"Error: {e}")
        pause()

def task_manager():
    print_header()
    print("Task Manager")
    if os.name == 'nt':
        cmd = 'tasklist'
    else:
        cmd = 'ps -aux'
    try:
        output = os.popen(cmd).read()
        print(output)
    except:
        print("Error retrieving process list.")
    pause()

def open_browser():
    print_header()
    print("Web Browser")
    url = input("Enter URL: ").strip()
    if url:
        if not url.startswith('http'):
            url = 'http://' + url
        webbrowser.open(url)
        print(f"Opening {url}...")
    pause()

def search_settings(users, username):
    print_border("Search Settings")
    term = input("Enter search term: ").lower()
    user_settings = users[username].get('settings', {})
    matches = []

    for k, v in user_settings.items():
        if term in k.lower() or term in v.lower():
            matches.append((k, v))
    print(f"\nFound {len(matches)} match(es).")
    for idx, (k, v) in enumerate(matches, 1):
        print(f"{idx}. {k}: {v}")

    if matches:
        while True:
            choice = input("Would you like to edit any of these? (y/n): ").lower()
            if choice == 'y':
                sel = input("Enter number of setting to edit (or '0' to cancel): ").strip()
                if sel.isdigit():
                    sel_idx = int(sel)
                    if sel_idx == 0:
                        break
                    elif 1 <= sel_idx <= len(matches):
                        key_to_edit = matches[sel_idx - 1][0]
                        current_value = user_settings[key_to_edit]
                        new_value = input(f"New value for '{key_to_edit}' (current: {current_value}): ").strip()
                        if new_value:
                            users[username]['settings'][key_to_edit] = new_value
                            save_users(users)
                            print(f"Updated '{key_to_edit}'.")
                        else:
                            print("No change made.")
                        break
                    else:
                        print("Invalid selection.")
                else:
                    print("Invalid input.")
            elif choice == 'n':
                break
            else:
                print("Please enter 'y' or 'n'.")
    pause()

def app_store():
    apps = [
        {"name": "Calculator", "description": "Basic calculator app."},
        {"name": "Notepad", "description": "Simple text editor."},
        {"name": "Web Browser", "description": "Browse the internet."},
        {"name": "Music Player", "description": "Play your music."},
        {"name": "Photo Viewer", "description": "View images."},
    ]
    while True:
        print_header()
        print("App Store")
        for idx, app in enumerate(apps, 1):
            print(f"{idx}. {app['name']} - {app['description']}")
        print(f"{len(apps)+1}. Return")
        choice = input(f"Select an app to install/launch (1-{len(apps)+1}): ").strip()
        if choice.isdigit():
            choice = int(choice)
            if 1 <= choice <= len(apps):
                print(f"Launching {apps[choice - 1]['name']}...")
                pause()
            elif choice == len(apps)+1:
                break
            else:
                print("Invalid selection.")
        else:
            print("Invalid input.")
        pause()

def reset_password(users, username):
    print_header()
    print("Reset Password")
    new_password = input("Enter new password: ").strip()
    if new_password:
        users[username]['password'] = new_password
        save_users(users)
        print("Password reset.")
    else:
        print("Password cannot be empty.")
    pause()

# Updated Settings Menu with Search & Make Changes
def settings_menu(users, username):
    # Initialize settings if not present
    if 'settings' not in users[username]:
        users[username]['settings'] = {}
    settings = users[username]['settings']
    
    settings.update({
        "Display Resolution": "1920x1080",
        "Display Brightness": "70%",
        "Display Refresh Rate": "60Hz",
        "Color Profile": "sRGB",
        "Night Light": "Off",
        "Wallpaper": "Sunset.jpg",
        "Sound Volume": "50%",
        "Microphone Volume": "80%",
        "Wi-Fi": "Connected",
        "Ethernet": "Connected",
        "IP Address": "192.168.1.100",
        "Firewall": "On",
        "VPN": "Disconnected",
        "Automatic Updates": "Enabled",
        "Windows Update Status": "Up to date",
        "Update Delivery Optimization": "Active",
        "Windows Defender Real-Time Protection": "On",
        "Firewall State": "On",
        "Firewall Notifications": "Enabled",
        "Firewall Log Size": "100 MB",
        "Firewall Log Path": "C:\\firewall_logs\\",
        "Firewall Rules Count": "25",
        "System Restore": "Enabled",
        "Restore Points Count": "5",
        "System Backup Scheduled": "Daily",
        "Backup Destination": "External Drive",
        "Cloud Backup Enabled": "Yes",
        "Disk Cleanup Schedule": "Weekly",
        "Disk Defragmentation Schedule": "Weekly",
        "Page File Size": "16 GB",
        "Virtual Memory Enabled": "Yes",
        "System Uptime": "7 days",
        "Last System Update": "2024-04-27",
        "System Boot Time": "2024-04-20 09:15",
        "System Language": "English",
        "System Locale": "en-US",
        "Time Zone": "UTC-5",
        "Date Format": "MM/DD/YYYY",
        "Time Format": "24-hour",
        "System Volume": "70%",
        "System Theme": "Dark",
        "Accent Color": "Blue",
        "Transparency Effects": "On",
        "Lock Screen Background": "Windows Spotlight",
        "Sign-in Options": "PIN and Password",
        "User Account Type": "Standard",
        "Default User Profile": "Default",
        "Guest Account": "Disabled",
        "Remote Desktop Enabled": "Yes",
        "Remote Assistance Enabled": "Yes",
        "Remote Desktop Port": "3389",
        "Remote Desktop Encryption": "High",
        "Remote Desktop Timeout": "30 minutes",
        "Windows Hello Face": "Configured",
        "Windows Hello Fingerprint": "Configured",
        "PIN Enabled": "Yes",
        "PIN Expiry": "60 days",
        "Password Expiry": "90 days",
        "Password Complexity": "High",
        "Account Lockout Threshold": "5 attempts",
        "Account Lockout Duration": "15 minutes",
        "Password History": "5 passwords",
        "Auto Login": "Enabled",
        "Login Timeout": "10 minutes",
        "Auto Lock Screen": "Enabled",
        "Lock Screen Timeout": "5 minutes",
        "Login Screen Background": "Custom",
        "Login Screen Timeout": "10 minutes",
        "Biometric Sign-in": "Enabled",
        "Fingerprint Scanner": "Active",
        "Face Recognition": "Active",
        "PIN Sign-in": "Enabled",
        "Windows Hello": "Configured",
        "Encrypted Drive": "BitLocker Enabled",
        "Device Encryption": "On",
        "Secure Boot": "Enabled",
        "TPM Version": "2.0",
        "UEFI Mode": "On",
        "Fast Boot": "Enabled",
        "Hardware Virtualization": "Enabled",
        "Intel VT-x": "On",
        "AMD-V": "On",
        "Secure Boot Keys": "Default",
        "BIOS Version": "1.2.3",
        "Firmware Version": "1.0.0",
        "Chassis Temperature": "36°C",
        "CPU Temperature": "55°C",
        "GPU Temperature": "60°C",
        "System Fan Speed": "Auto",
        "Power Supply Status": "Good",
        "UPS Battery Status": "Full",
        "Cooling System": "Optimal",
        "Hardware Sensors": "All OK",
        "Hardware Diagnostics": "Passed",
        "Battery Wear Level": "12%",
        "Battery Cycles": "300",
        "Battery Voltage": "11.4V",
        "Battery Capacity": "50 Wh",
        "Charging Rate": "Fast",
        "Power Adapter Wattage": "65W",
        "System Power Mode": "High Performance",
        "Energy Saver Mode": "On",
        "Sleep Mode": "Enabled",
        "Hibernate Mode": "Enabled",
        "Auto Sleep After": "10 minutes",
        "Display Sleep Timeout": "5 minutes",
        "Battery Charge Threshold": "80%",
        "Battery Discharge Rate": "High",
        "Battery Temperature": "35°C",
        "Power Consumption": "Moderate",
        "System Temperature": "50°C",
        "CPU Temperature": "55°C",
        "GPU Temperature": "60°C",
        "Fan Speed": "Auto",
        "CPU Load": "15%",
        "GPU Load": "20%",
        "Memory Usage": "40%",
        "Disk Usage": "50%",
        "Network Usage": "10 Mbps",
        "Wi-Fi Signal Strength": "Excellent",
        "Ethernet Link Speed": "1 Gbps",
        "Bluetooth Power": "On",
        "Bluetooth Devices": "Keyboard, Mouse",
        "External Microphone": "Connected",
        "External Speakers": "Connected",
        "Display Brightness": "80%",
        "Display Contrast": "Default",
        "Display Calibration": "Default",
        "Color Calibration Date": "2024-04-01",
        "Night Light": "On",
        "Night Light Schedule": "Sunset to Sunrise",
        "Dark Mode": "Enabled",
        "Light Mode": "Disabled",
        "Wallpaper": "Nature.jpg",
        "Wallpaper Slideshow": "On",
        "Wallpaper Change Interval": "1 hour",
        "Screensaver": "Photos",
        "Screensaver Timeout": "10 minutes",
        "Wallpaper Folder": "C:\\Wallpapers",
        "Background Apps": "All Allowed",
        "Auto Brightness": "On",
        "Display Scaling": "125%",
        "Display Resolution": "3840x2160",
        "External Display Resolution": "1920x1080",
        "Monitor Refresh Rate": "144Hz",
        "Monitor Brightness": "75%",
        "Monitor Power Saving": "On",
        "External Monitor Brightness": "70%",
        "External Monitor Power Saving": "On",
        "Projector Mode": "Off",
        "Projection Screen": "Off",
        "Projection Mode": "Duplicate",
        "Dual Display Mode": "Extend",
        "Display Orientation": "Landscape",
        "Display Rotation": "0°",
        "Display Overlays": "Off",
        "Color Profile": "sRGB",
        "Color Calibration": "Default",
        "Brightness Level": "70%",
        "Contrast Level": "Default",
        "Gamma Settings": "Default",
        "HDR Mode": "Off",
        "HDR Brightness": "1000 nits",
        "HDR Contrast": "High",
        "HDR Content Mode": "Gaming",
        "Display HDR": "Enabled",
        "Display HDR Content": "Supported",
        "Input Devices": "Keyboard, Mouse, Touchscreen",
        "Keyboard Backlight": "On",
        "Keyboard Layout": "US",
        "Keyboard Language": "English",
        "Keyboard Shortcuts": "All Enabled",
        "Mouse Sensitivity": "Medium",
        "Trackpad Sensitivity": "Medium",
        "Touchpad Gestures": "Enabled",
        "Pen Input": "Active",
        "Pen Pressure Sensitivity": "High",
        "Stylus Button": "Configured",
        "Camera Resolution": "1920x1080",
        "Camera Brightness": "70%",
        "Microphone Volume": "80%",
        "Microphone Noise Suppression": "On",
        "Speaker Volume": "70%",
        "Audio Balance": "Center",
        "Audio Output Device": "Speakers",
        "Audio Input Device": "Microphone",
        "Sound Effects": "On",
        "Audio Enhancements": "Bass Boost",
        "Headphone Volume": "70%",
        "Headphone Microphone": "Connected",
        "External Speakers Volume": "70%",
        "Speaker Mode": "Stereo",
        "Audio Device Drivers": "Up to date",
        "Microphone Drivers": "Up to date",
        "Bluetooth Driver": "Up to date",
        "Wi-Fi Driver": "Up to date",
        "Ethernet Driver": "Up to date",
        "Graphics Driver": "Up to date",
        "Audio Driver": "Up to date",
        "Camera Driver": "Up to date",
        "System Driver": "Up to date",
        "Device Manager": "All devices working",
        "Event Viewer": "No critical errors",
        "System Logs": "Clean",
        "Security Logs": "Clean",
        "Application Logs": "Clean",
        "Hardware Sensors": "All OK",
        "Diagnostics": "Passed",
        "Error Reports": "None",
        "Security Alerts": "None",
        "System Alerts": "None",
        "Battery Status": "Good",
        "Battery Health": "Healthy",
        "Battery Cycles": "300",
        "Battery Temperature": "35°C",
        "Battery Voltage": "11.4V",
        "Battery Capacity": "50 Wh",
        "Charging Rate": "Fast",
        "Power Source": "AC",
        "UPS Battery Level": "Full",
        "UPS Status": "Operational",
        "Power Consumption": "Moderate",
        "Energy Usage": "Normal",
        "System Power Plan": "High Performance",
        "Sleep Mode": "Enabled",
        "Hibernate": "Enabled",
        "Auto Sleep": "10 minutes",
        "Display Sleep": "5 minutes",
        "Monitor Sleep": "10 minutes",
        "System Temperature": "50°C",
        "CPU Temperature": "55°C",
        "GPU Temperature": "60°C",
        "Fan Speed": "Auto",
        "CPU Load": "20%",
        "GPU Load": "25%",
        "Memory Usage": "40%",
        "Disk Usage": "45%",
        "Network Usage": "10 Mbps",
        "Wi-Fi Signal": "Excellent",
        "Ethernet Link": "Active",
        "Network Latency": "20 ms",
        "Ping Test": "Successful",
        "Port Status": "Open",
        "Firewall Status": "Active",
        "Antivirus Status": "Active",
        "Malware Scan": "Last run 1 day ago",
        "Ad Blocker": "On",
        "Browsing Security": "Default",
        "Cookies": "Allowed",
        "Pop-ups": "Blocked",
        "JavaScript": "Enabled",
        "Tracking Prevention": "High",
        "Password Manager": "Active",
        "Browsing History": "Clean",
        "Bookmarks": "Saved",
        "Extensions": "All Enabled",
        "Default Search Engine": "Google",
        "Sync Settings": "On",
        "Favorite Sites": "List of sites",
        "Download Folder": "C:\\Downloads",
        "Downloads in Background": "On",
        "File Sharing": "Allowed",
        "Printer Status": "Ready",
        "Printer Queue": "Empty",
        "Printer Paper Level": "Full",
        "Printer Ink Level": "High",
        "Connected Printers": "HP LaserJet",
        "External Drives": "Connected",
        "USB Devices": "All recognized",
        "External Monitors": "2 connected",
        "Docking Station": "Connected",
        "Docking Station Ports": "All functional",
        "Laptop Lid Closed": "Sleep",
        "External Keyboard": "Connected",
        "External Mouse": "Connected",
        "External Speakers": "Connected",
        "Headphones": "Connected",
        "Microphone": "Connected",
        "Webcam": "Active",
        "Camera Privacy": "On",
        "Camera Resolution": "1920x1080",
        "Webcam Driver": "Up to date",
        "Microphone Driver": "Up to date",
        "System Volume": "70%",
        "Notification Settings": "All enabled",
        "Focus Assist": "Off",
        "Night Light": "On",
        "Dark Mode": "Enabled",
        "Accent Color": "Blue",
        "Transparency Effects": "On",
        "Wallpaper": "Nature.jpg",
        "Lock Screen Background": "Windows Spotlight",
        "Sign-in Options": "Password, PIN",
        "User Account": "Admin",
        "Account Type": "Administrator",
        "Family Safety": "Off",
        "Parental Controls": "Off",
        "User Profiles": "Default",
        "Guest Account": "Disabled",
        "Remote Desktop": "Allowed",
        "Remote Assistance": "Allowed",
        "Remote Desktop Port": "3389",
        "Remote Desktop Encryption": "High",
        "VPN": "Connected",
        "VPN Protocol": "IKEv2",
        "VPN Server": "vpn.company.com",
        "VPN Encryption": "AES-256",
        "Proxy Enabled": "No",
        "Proxy Address": "",
        "Proxy Port": "",
        "Network Isolation": "Enabled",
        "Data Encryption": "AES-256",
        "Secure Boot": "On",
        "TPM": "Activated",
        "Firmware Version": "1.2.3",
        "BIOS Version": "1.2.3",
        "UEFI Mode": "On",
        "Fast Boot": "Enabled",
        "Hardware Virtualization": "Enabled",
        "Intel VT-x": "On",
        "AMD-V": "On",
        "Secure Boot Keys": "Default",
        "System Firmware": "UEFI",
        "Chassis Temperature": "36°C",
        "CPU Temperature": "55°C",
        "GPU Temperature": "60°C",
        "Fan Speed": "Auto",
        "Power Supply": "Good",
        "Cooling Fans": "All OK",
        "Voltage Levels": "Stable",
        "Current Draw": "Within Limits",
        "Component Status": "Healthy",
        "System Overall Status": "Operational",
        "Event Log": "No recent errors",
        "Diagnostics": "Passed",
        "Hardware Sensors": "All OK",
        "System Alerts": "None",
        "Battery Level": "85%",
        "Battery Capacity": "50 Wh",
        "Battery Voltage": "11.4V",
        "Battery Temperature": "36°C",
        "Battery Cycles": "250",
        "Battery Wear Level": "12%",
        "Charging Status": "Charging",
        "Charging Rate": "Fast",
        "Power Adapter Wattage": "65W",
        "UPS Power": "Operational",
        "UPS Battery Level": "Full",
        "UPS Status": "Running",
        "Power Consumption": "Moderate",
        "Energy Usage": "Normal",
        "System Power Mode": "High Performance",
        "Sleep Mode": "On",
        "Hibernate Mode": "On",
        "Auto Sleep After": "10 minutes",
        "Display Sleep Timeout": "5 minutes",
        "Monitor Sleep Timeout": "10 minutes",
        "Security Software": "Windows Defender",
        "Malware Scanner": "Active",
        "Firewall Rules": "Default",
        "Antivirus Signature Date": "2024-04-20",
        "Firewall Log": "No recent blocks",
        "Network Security": "High",
        "Data Sharing": "Off",
        "File Encryption": "AES-256",
        "Data Backup": "Scheduled",
        "Backup Frequency": "Daily",
        "Backup Destination": "Cloud",
        "Cloud Storage": "OneDrive",
        "Cloud Sync": "On",
        "Cloud Storage Quota": "50 GB",
        "Disk Encryption": "BitLocker",
        "Drive Health": "Good",
        "SSD Trim": "Enabled",
        "HDD Defragmentation": "Weekly",
        "System Health Check": "Passed",
        "Application Updates": "Auto",
        "Driver Updates": "Auto",
        "Windows Update": "Auto",
        "Security Patches": "Applied",
        "User Account Control": "Enabled",
        "Password Policy": "Strong",
        "Account Lockout Policy": "5 attempts",
        "Password Expiry": "90 days",
        "Password History": "5",
        "Automatic Login": "Enabled",
        "Login Timeout": "10 minutes",
        "Login Screen Background": "Default",
        "Login Options": "Password, PIN",
        "Biometric Login": "Enabled",
        "Fingerprint Reader": "Active",
        "Face Recognition": "Active",
        "PIN Sign-in": "Enabled",
        "Windows Hello": "Configured",
        "Device Encryption": "On",
        "Secure Boot": "On",
        "TPM Version": "2.0",
        "UEFI Firmware": "On",
        "Fast Boot": "Enabled",
        "Hardware Virtualization": "Enabled",
        "Intel VT-x": "On",
        "AMD-V": "On",
        "Secure Boot Keys": "Default",
        "System Firmware Version": "1.2.3",
        "Chassis Temperature": "36°C",
        "CPU Temperature": "55°C",
        "GPU Temperature": "60°C",
        "Fan Speed": "Auto",
        "Power Supply Status": "Good",
        "Cooling System": "Optimal",
        "Voltage Levels": "Stable",
        "Current Draw": "Within Limits",
        "Component Status": "Healthy",
        "System Overall Health": "Excellent",
        "Event Log": "Clean",
        "Error Reports": "None",
        "Hardware Sensors": "All OK",
        "Network Interface Cards": "2",
        "Wi-Fi Adapter": "Intel Wireless-AC 9560",
        "Ethernet Adapter": "Realtek PCIe GBE",
        "Bluetooth Adapter": "Intel Bluetooth",
        "Sound Card": "Realtek HD Audio",
        "Webcam": "Built-in HD",
        "Microphone": "Built-in",
        "Speakers": "Built-in",
        "External Microphone": "Connected",
        "External Speakers": "Connected",
        "Display Adapter": "NVIDIA GTX 1650",
        "Monitor Resolution": "2560x1440",
        "Monitor Refresh Rate": "144Hz",
        "Display Brightness": "80%",
        "Display Contrast": "Default",
        "Color Calibration Date": "2024-04-01",
        "Night Light Schedule": "Sunset to Sunrise",
        "Dark Mode": "On",
        "Wallpaper": "Nature.jpg",
        "Lock Screen Background": "Windows Spotlight",
        "Sign-in Options": "Password, PIN",
        "User Profile": "Default",
        "Account Type": "Administrator",
        "Family Safety": "Off",
        "Parental Controls": "Off",
        "User Profiles": "Default",
        "Remote Desktop": "Allowed",
        "Remote Assistance": "Allowed",
        "Remote Desktop Port": "3389",
        "Remote Desktop Encryption": "High",
        "VPN": "Connected",
        "VPN Protocol": "IKEv2",
        "VPN Server": "vpn.company.com",
        "VPN Encryption": "AES-256",
        "Proxy Enabled": "No",
        "Proxy Address": "",
        "Proxy Port": "",
        "Network Isolation": "Enabled",
        "Data Encryption": "AES-256",
        "Secure Boot": "On",
        "TPM": "Activated",
        "Firmware Version": "1.2.3",
        "BIOS Version": "1.2.3",
        "UEFI Mode": "On",
        "Fast Boot": "Enabled",
        "Hardware Virtualization": "Enabled",
        "Intel VT-x": "On",
        "AMD-V": "On",
        "Secure Boot Keys": "Default",
        "System Firmware": "UEFI",
        "Chassis Temperature": "36°C",
        "CPU Temperature": "55°C",
        "GPU Temperature": "60°C",
        "Fan Speed": "Auto",
        "Power Supply": "Good",
        "Cooling Fans": "All OK",
        "Voltage Levels": "Stable",
        "Current Draw": "Within Limits",
        "Component Status": "Healthy",
        "System Overall Status": "Operational",
        "Event Log": "No recent errors",
        "Diagnostics": "Passed",
        "Hardware Sensors": "All OK",
        "System Alerts": "None",
        "Battery Level": "85%",
        "Battery Capacity": "50 Wh",
        "Battery Voltage": "11.4V",
        "Battery Temperature": "36°C",
        "Battery Cycles": "250",
        "Battery Wear Level": "12%",
        "Charging Status": "Charging",
        "Power Adapter Wattage": "65W",
        "UPS Power": "Operational",
        "UPS Battery Level": "Full",
        "UPS Status": "Running",
        "Power Consumption": "Moderate",
        "Energy Usage": "Normal",
        "System Power Mode": "High Performance",
        "Sleep Mode": "On",
        "Hibernate Mode": "On",
        "Auto Sleep After": "10 minutes",
        "Display Sleep Timeout": "5 minutes",
        "Monitor Sleep Timeout": "10 minutes",
        "Security Software": "Windows Defender",
        "Malware Scanner": "Active",
        "Firewall Rules": "Default",
        "Antivirus Signature Date": "2024-04-20",
        "Firewall Log": "No recent blocks",
        "Network Security": "High",
        "Data Sharing": "Off",
        "File Encryption": "AES-256",
        "Data Backup": "Scheduled",
        "Backup Frequency": "Daily",
        "Backup Destination": "Cloud",
        "Cloud Storage": "OneDrive",
        "Cloud Sync": "On",
        "Cloud Storage Quota": "50 GB",
        "Disk Encryption": "BitLocker",
        "Drive Health": "Good",
        "SSD Trim": "Enabled",
        "HDD Defragmentation": "Weekly",
        "System Health Check": "Passed",
        "Application Updates": "Auto",
        "Driver Updates": "Auto",
        "Windows Update": "Auto",
        "Security Patches": "Applied",
        "User Account Control": "Enabled",
        "Password Policy": "Strong",
        "Account Lockout Threshold": "5 attempts",
        "Account Lockout Duration": "15 minutes",
        "Password Expiry": "90 days",
        "Password History": "5",
        "Auto Login": "Enabled",
        "Login Timeout": "10 minutes",
        "Auto Lock Screen": "Enabled",
        "Lock Screen Timeout": "5 minutes",
        "Login Screen Background": "Default",
        "Login Options": "Password, PIN",
        "Biometric Sign-in": "Enabled",
        "Fingerprint Scanner": "Active",
        "Face Recognition": "Active",
        "PIN Sign-in": "Enabled",
        "Windows Hello": "Configured",
        "Automatic Updates": "Enabled",
        "Windows Update Status": "Up to date",
        "Update Delivery Optimization": "Active",
        "Windows Defender Real-Time Protection": "On",
        "Windows Defender Cloud Protection": "On",
        "Windows Defender Automatic Sample Submission": "On",
        "Firewall State": "On",
        "Firewall Notifications": "Enabled",
        "Firewall Log Size": "100 MB",
        "Firewall Blocked Connections": "0",
        "Firewall Allowed Connections": "10",
        "Firewall Rules Count": "25",
        "Network Profile": "Private",
        "Wi-Fi Auto Connect": "Yes",
        "Wi-Fi Hotspot": "Off",
        "Bluetooth Discoverable": "On",
        "Bluetooth Devices List": "Keyboard, Headphones",
        "USB Devices Connected": "5",
        "External Storage Devices": "2",
        "Connected Printers": "HP LaserJet",
        "External Displays": "2",
        "Monitor Resolution": "2560x1440",
        "Monitor Refresh Rate": "144Hz",
        "Display Brightness Level": "80%",
        "Display Timeout": "10 minutes",
        "Night Light": "On",
        "Night Light Schedule": "Sunset to Sunrise",
        "Color Calibration": "Advanced",
        "Screen Orientation": "Landscape",
        "Screen Scaling": "125%",
        "Desktop Icon Size": "Medium",
        "Taskbar Position": "Bottom",
        "Taskbar Auto-hide": "Off",
        "Start Menu Layout": "Default",
        "Wallpaper Slideshow": "Enabled",
        "Wallpaper Change Interval": "30 minutes",
        "Screensaver Timeout": "15 minutes",
        "Screensaver Type": "Photos",
        "Display Color Depth": "32-bit",
        "Display Connection Type": "HDMI",
        "Sound Output Device": "Speakers",
        "Sound Input Device": "Microphone",
        "Volume Level": "70%",
        "Microphone Volume": "85%",
        "Speaker Volume": "70%",
        "Sound Effects": "On",
        "Bass Boost": "Enabled",
        "Surround Sound": "Off",
        "Audio Output Format": "Stereo",
        "Audio Sample Rate": "44100 Hz",
        "Microphone Boost": "Enabled",
        "Bluetooth Power": "On",
        "Bluetooth Visibility": "Visible",
        "Bluetooth Pairing Mode": "Automatic",
        "Bluetooth Devices Paired": "Headphones, Mouse",
        "Network Adapter Type": "Wi-Fi",
        "Ethernet Speed": "1 Gbps",
        "Wi-Fi Signal Strength": "Strong",
        "Wi-Fi Channel": "11",
        "Wi-Fi Band": "5 GHz",
        "VPN Connection": "Active",
        "VPN Protocol": "OpenVPN",
        "VPN Server": "vpn.company.com",
        "VPN Encryption": "AES-256",
        "Proxy Server Enabled": "No",
        "Proxy Server Address": "",
        "Proxy Server Port": "",
        "NAT Type": "Open",
        "IPV6 Support": "Enabled",
        "IPv4 Support": "Enabled",
        "Default DNS": "8.8.8.8",
        "Alternate DNS": "8.8.4.4",
        "DHCP Enabled": "Yes",
        "Static IP Address": "192.168.1.150",
        "Subnet Mask": "255.255.255.0",
        "Default Gateway": "192.168.1.1",
        "MAC Address": "00:1A:2B:3C:4D:5F",
        "IPv6 Address": "fe80::1a2b:3c4d:5e6f",
        "Network MTU": "1500",
        "Packet Size": "1500 bytes",
        "Firewall Rules": "Default",
        "Port Forwarding": "None",
        "UPnP Enabled": "Yes",
        "QoS Enabled": "Yes",
        "Bandwidth Limit": "Unlimited",
        "Data Usage This Month": "2.5 GB",
        "Network Traffic": "Idle",
        "Connection Timeout": "30 seconds",
        "DNS Cache Size": "1024 KB",
        "ARP Cache": "Active",
        "Routing Table": "Default routes",
        "IPv4 Routing": "Active",
        "IPv6 Routing": "Active",
        "Network Interface Status": "Up",
        "Power Saving Mode": "Enabled",
        "Sleep Mode": "Enabled",
        "Hibernate Mode": "Enabled",
        "Auto Sleep After": "10 minutes",
        "Display Sleep Timeout": "5 minutes",
        "System Sleep Timeout": "15 minutes",
        "Battery Charge Threshold": "80%",
        "Battery Discharge Rate": "High",
        "Battery Cycle Count": "200",
        "Battery Wear Level": "10%",
        "Battery Voltage": "11.4V",
        "Battery Temperature": "35°C",
        "Power Source": "AC",
        "Charging Rate": "Fast",
        "Power Saver Profile": "Maximum",
        "System Temperature": "50°C",
        "CPU Temperature": "55°C",
        "GPU Temperature": "60°C",
        "Fan Speed": "Auto",
        "CPU Load": "15%",
        "GPU Load": "20%",
        "Memory Usage": "35%",
        "Disk Usage": "45%",
        "Network Usage": "5 Mbps",
        "Wireless Signal Strength": "Excellent",
        "Ethernet Link Speed": "1 Gbps",
        "Device Driver Version": "460.79",
        "System Uptime": "5 days",
        "Last System Update": "2024-04-27",
        "System Boot Time": "2024-04-22 09:15",
        "System Locale": "en-US",
        "Language Pack": "English",
        "Input Method": "US Keyboard",
        "Keyboard Layout": "US",
        "Display Language": "English",
        "Region": "United States",
        "Time Format": "24-hour",
        "Date Format": "MM/DD/YYYY",
        "Accessibility Features": "On",
        "Magnifier": "Off",
        "Narrator": "Off",
        "High Contrast Mode": "Off",
        "Color Filters": "None",
        "Speech Recognition": "Off",
        "Keyboard Shortcuts": "Enabled",
        "Auto Lock Screen": "Enabled",
        "Lock Screen Timeout": "5 minutes",
        "Login Screen Timeout": "10 minutes",
        "Windows Hello Enabled": "Yes",
        "Biometric Devices": "Fingerprint, Face ID",
        "PIN Code Enabled": "Yes",
        "Password Expiry": "90 days",
        "Account Lockout Threshold": "5 attempts",
        "Account Lockout Duration": "15 minutes",
        "Password Complexity Requirements": "Strong",
        "User Accounts": "Admin, Standard",
        "Default User": "Admin",
        "Guest Account": "Disabled",
        "Remote Desktop Access": "Allowed",
        "Remote Assistance": "Allowed",
        "Remote Desktop Port": "3389",
        "Remote Desktop Encryption": "High",
        "Remote Desktop Timeout": "30 minutes",
        "System Restore Points": "Multiple",
        "System Backup Enabled": "Yes",
        "Backup Frequency": "Daily",
        "Backup Destination": "External Drive",
        "Cloud Backup": "Enabled",
        "File History Enabled": "Yes",
        "Sync Settings": "On",
        "OneDrive Sync": "Active",
        "Dropbox Sync": "Inactive",
        "Google Drive Sync": "Active",
        "Cloud Storage Quota": "50 GB",
        "Disk Cleanup Scheduled": "Weekly",
        "Disk Defragmentation Schedule": "Weekly",
        "Page File Size": "16 GB",
        "Virtual Memory": "Enabled",
        "Windows Update Channel": "Semi-Annual",
        "Update Install Time": "2 AM",
        "Driver Updates": "Automatic",
        "Security Updates": "Automatic",
        "Firewall Rules": "Default",
        "Antivirus Enabled": "Yes",
        "Antivirus Real-time Protection": "On",
        "Antivirus Scheduled Scan": "Weekly",
        "Malware Protection": "Enabled",
        "Spyware Protection": "Enabled",
        "Ad Blocker": "Active",
        "Browser Security Settings": "Default",
        "Cookies Enabled": "Yes",
        "Pop-ups Blocked": "Yes",
        "JavaScript Enabled": "Yes",
        "Tracking Prevention": "Balanced",
        "Password Manager": "Enabled",
        "VPN Auto Connect": "Yes",
        "Proxy Auto Detect": "Enabled",
        "Firewall Notification": "On",
        "Network Discovery": "On",
        "File Sharing": "On",
        "Printer Sharing": "On",
        "Media Streaming": "Allowed",
        "Remote Management": "On",
        "Wi-Fi Hotspot": "Off",
        "Data Usage Limit": "Unlimited",
        "Bandwidth Allocation": "Default",
        "QoS Settings": "Default",
        "Network Priority": "Normal",
        "System Performance Mode": "High",
        "Overclocking": "Off",
        "GPU Overclocking": "Off",
        "CPU Overclocking": "Off",
        "RAM Speed": "2666 MHz",
        "SSD Trim": "Enabled",
        "HDD Defragmentation": "Scheduled",
        "SSD Firmware Update": "Available",
        "Disk Encryption": "AES256",
        "Secure Boot": "Enabled",
        "TPM Module": "Activated",
        "BIOS Version": "1.2.3",
        "UEFI Mode": "On",
        "Fast Boot": "Enabled",
        "Secure Boot Mode": "Standard",
        "Hardware Virtualization": "Enabled",
        "Intel VT-x": "On",
        "AMD-V": "On",
        "TPM Version": "2.0",
        "System Firmware Version": "1.0.0",
        "Device Manager": "All devices working",
        "Event Logging": "On",
        "System Alerts": "None",
        "Hardware Diagnostics": "Passed",
        "Power Supply Status": "Good",
        "UPS Battery Status": "Full",
        "Cooling System": "Optimal",
        "Chassis Temperature": "36°C",
        "Hardware Sensors": "All OK",
        "Network Interface Cards": "2",
        "Wi-Fi Adapter": "Intel Wireless-AC 9560",
        "Ethernet Adapter": "Ethernet Controller",
        "Bluetooth Adapter": "Intel Bluetooth",
        "Sound Card": "Realtek HD Audio",
        "Webcam": "Integrated HD",
        "Microphone": "Built-in",
        "Speakers": "Built-in",
        "External Microphone": "Disabled",
        "External Speakers": "Connected",
        "Display Adapter": "NVIDIA GTX 1650",
        "Monitor EDID Info": "Supported",
        "Display Color Calibration": "Default",
        "Power Consumption": "Balanced",
        "Energy Usage": "Moderate",
        "System Noise Level": "Quiet",
        "Fan Speed": "Auto",
        "Temperature Sensors": "All OK",
        "Voltage Levels": "Normal",
        "Current Draw": "Within limits",
        "Component Status": "Healthy",
        "System Health": "Excellent",
        "Battery Wear Level": "10%",
        "Battery Cycles": "250",
        "Battery Voltage": "11.4V",
        "Battery Capacity": "50 Wh",
        "Battery Design Capacity": "50 Wh",
        "Charging Rate": "Fast",
        "Power Adapter Wattage": "65W",
        "UPS Wattage": "1500W",
        "Power Saving Plans": "Balanced, Power Saver, High Performance",
        "Battery Saver Mode": "On",
        "Auto Brightness": "On",
        "Night Light": "On",
        "Color Calibration Profile": "sRGB",
        "Display Calibration Date": "2024-04-01",
        "Screen Saver": "Photos",
        "Screen Saver Timeout": "10 minutes",
        "Screen Saver Slideshow": "Enabled",
        "Wallpaper Slideshow": "On",
        "Wallpaper Change Interval": "1 hour",
        "Desktop Icon Size": "Large",
        "Taskbar Transparency": "Enabled",
        "Start Menu Layout": "Default",
        "Task View": "Enabled",
        "Virtual Desktops": "3",
        "Voice Assistants": "Cortana",
        "Speech Recognition": "Configured",
        "Dictation": "On",
        "Clipboard History": "Enabled",
        "Clipboard Sync": "On",
        "Auto HDR": "On",
        "Game Mode": "On",
        "Xbox Game Bar": "Active",
        "Gaming Graphics Settings": "Optimized",
        "Frame Rate Limit": "60 FPS",
        "Capture Settings": "Default",
        "Microphone Sensitivity": "80%",
        "Game DVR": "Enabled",
        "Audio Enhancements": "Bass Boost",
        "Display Overlays": "Off",
        "Notification Center": "Enabled",
        "Focus Assist": "Off",
        "Quiet Hours": "Off",
        "Night Mode": "On",
        "Night Light Schedule": "Sunset to Sunrise",
        "Read Mode": "Off",
        "Dark Mode": "On",
        "Accent Color": "Blue",
        "Transparency Effects": "On",
        "Windows Theme": "Dark",
        "Personalization": "Standard",
        "Lock Screen Background": "Windows Spotlight",
        "Sign-in Options": "Password, PIN",
        "User Pictures": "Default",
        "Account Settings": "Standard User",
        "Family Safety": "Off",
        "Parental Controls": "Off",
        "User Accounts": "Admin, Guest",
        "Remote Desktop": "Enabled",
        "Remote Desktop Users": "Admin",
        "Remote Assistance": "On",
        "Remote Desktop Port": "3389",
        "Network Sharing": "On",
        "Network Discovery": "On",
        "File Sharing": "On",
        "Printer Sharing": "On",
        "Media Streaming": "Allowed",
        "HomeGroup": "Not Joined",
        "Network Profile": "Private",
        "Public Folder Sharing": "On",
        "Printer Queue": "Idle",
        "Device Installations": "Automatic",
        "Driver Signature Enforcement": "On",
        "Driver Updates": "Automatic",
        "System Updates": "Automatic",
        "Windows Defender": "On",
        "Malware Protection": "Active",
        "Spyware Protection": "Active",
        "Ad Blocker": "On",
        "Browser Settings": "Default",
        "Cookies": "Allowed",
        "Pop-ups": "Blocked",
        "JavaScript": "Enabled",
        "Tracking Prevention": "Strict",
        "Password Manager": "Enabled",
        "Browsing History": "Saved",
        "Form Autofill": "On",
        "Autofill Passwords": "On",
        "Search Engine": "Default",
        "Sync Settings": "On",
        "Bookmarks": "Saved",
        "Extensions": "Installed",
        "Security Certificates": "Valid",
        "Secure DNS": "Enabled",
        "VPN Auto Reconnect": "Yes",
        "VPN Kill Switch": "Enabled",
        "Proxy Settings": "Off",
        "Network Isolation": "Enabled",
        "Data Encryption": "AES-256",
        "Secure Boot Mode": "Standard",
        "TPM Version": "2.0",
        "UEFI Secure Boot": "On",
        "Hardware TPM": "Activated",
        "BIOS Version": "1.2.3",
        "System Firmware": "UEFI",
        "Fast Boot": "Enabled",
        "Overclocking": "Off",
        "GPU Overclocking": "Off",
        "CPU Overclocking": "Off",
        "Core Voltage": "Normal",
        "Memory Speed": "2666 MHz",
        "SSD Trim": "Enabled",
        "HDD Defragmentation": "Scheduled",
        "Secure Boot Keys": "Default",
        "TPM Chip": "Enabled",
        "System Health Check": "Passed",
        "Hardware Diagnostics": "Healthy",
        "Power Supply": "Good",
        "Chassis Temperature": "36°C",
        "Cooling Fans": "All Normal",
        "Voltage Levels": "Stable",
        "Current Draw": "Within Limits",
        "Component Status": "Healthy",
        "System Overall Health": "Excellent",
        "Event Log": "Cleared",
        "Error Reports": "No errors",
        "System Alerts": "None",
        "Hardware Sensors": "All OK",
        "Network Interfaces": "2",
        "Wi-Fi Adapter": "Intel Wireless-AC 9560",
        "Ethernet Adapter": "Realtek PCIe GBE",
        "Bluetooth Adapter": "Intel Bluetooth",
        "Sound Card": "Realtek HD Audio",
        "Webcam": "Integrated HD",
        "Microphone": "Built-in",
        "Speakers": "Built-in",
        "External Microphone": "Connected",
        "External Speakers": "Connected",
        "Display Adapter": "NVIDIA GTX 1650",
        "Monitor Resolution": "2560x1440",
        "Monitor Refresh Rate": "144Hz",
        "Monitor Color Profile": "sRGB",
        "Display Brightness": "80%",
        "Display Contrast": "Default",
        "Color Calibration Date": "2024-03-15",
        "Screen Brightness Auto": "On",
        "Display Scaling": "125%",
        "Night Light Schedule": "Sunset to Sunrise",
        "Display Overlays": "Off",
        "Active Windows": "3",
        "Running Processes": "125",
        "Installed Applications": "List of 50+ apps",
        "Startup Programs": "Antivirus, CloudSync",
        "Background Apps": "All Allowed",
        "Windows Defender Real-Time Protection": "On",
        "Firewall Rules": "Default",
        "Malwarebytes": "Active",
        "Antivirus Signature Date": "2024-04-25",
        "System Restore Enabled": "Yes",
        "Restore Points": "Multiple",
        "Disk Usage": "45%",
        "RAM Usage": "35%",
        "CPU Load": "20%",
        "GPU Load": "15%",
        "Network Speed": "500 Mbps",
        "Data Transfer Rate": "50 Mbps",
        "Bluetooth Devices": "Keyboard, Mouse",
        "Connected USB Devices": "3",
        "External Storage Devices": "2",
        "External Displays": "2",
        "Game Mode": "On",
        "Recording Devices": "Microphone, Headset",
        "Audio Output": "Dolby Atmos",
        "Audio Input": "Stereo Mix",
        "Virtual Desktops": "3",
        "Clipboard History": "On",
        "Night Mode": "On",
        "Dark Mode": "Enabled",
        "Accent Color": "Blue",
        "Transparency Effects": "On",
        "Windows Theme": "Dark",
        "Wallpaper": "Nature.jpg",
        "Lock Screen Background": "Windows Spotlight",
        "Sign-in Options": "Password, PIN",
        "User Account Type": "Standard",
        "Parental Controls": "Off",
        "Family Safety": "Off",
        "Account Lockout Threshold": "5 attempts",
        "Account Lockout Duration": "15 minutes",
        "Password Expiration": "90 days",
        "Password Complexity": "High",
        "Auto Login": "Enabled",
        "Login Timeout": "10 minutes",
        "PIN Lockout": "5 failed attempts",
        "Biometric Login": "Enabled",
        "Windows Hello Face": "Configured",
        "Windows Hello Fingerprint": "Configured",
        "User Pictures": "Default",
        "Default Apps": "Edge, Mail, Photos",
        "Webcam Privacy": "On",
        "Microphone Privacy": "On",
        "Camera Access for Apps": "Allowed",
        "Microphone Access for Apps": "Allowed",
        "Remote Desktop Access": "Allowed",
        "Remote Assistance": "Enabled",
        "Network Profile": "Private",
        "Public IP": "203.0.113.45",
        "Private IP": "192.168.1.150",
        "IPv6 Address": "fe80::1a2b:3c4d:5e6f",
        "Display Resolution": "1920x1080",
        "Display Brightness": "70%",
        "Firewall Enabled": "Yes",
        "Firewall Logging": "Enabled",
        "Firewall Log Path": "C:\\firewall_logs\\",
        "Network Adapter Power Saving": "On",
        "Wi-Fi Power Save Mode": "On",
        "Bluetooth Visibility": "Visible",
        "Bluetooth Device Name": "MyDevice",
        "USB Power Saving Mode": "Enabled",
        "USB Selective Suspend": "Enabled",
        "Power Management for USB": "Maximum Power Saving",
        "Network Buffer Size": "8192",
        "TCP Window Size": "65536",
        "IPv6 Privacy Extensions": "On",
        "IPv4 Routing Table": "Default routes",
        "IPv6 Routing Table": "Default routes",
        "Packet Filtering": "On",
        "Firewall Rules Enabled": "Yes",
        "Firewall Logging Level": "Verbose",
        "Port Forwarding Rules": "None",
        "NAT Traversal": "Enabled",
        "VPN Kill Switch": "On",
        "Network Authentication": "WPA2-Personal",
        "Network Encryption": "AES",
        "Network Interface Statistics": "Active",
        "MAC Address Randomization": "On",
        "IPv4 Fragmentation": "Enabled",
        "IPv6 Privacy Extensions": "On",
        "DHCP Server Status": "Active",
        "DNS Cache Size": "512 KB",
        "ARP Cache": "Active",
        "Routing Table": "Default routes",
        "Firewall Profile Type": "Public",
        "Packet Inspection": "Active",
        "QoS Packet Scheduler": "Enabled",
        "Bandwidth Limiting": "Off",
        "Network Load Balancing": "Disabled",
        "Network Interface Priority": "High",
        "Network Adapter Wake-on-LAN": "Enabled",
        "Wireless Roaming": "On",
        "Wireless Signal Auto-Adjustment": "On",
        "Wi-Fi Bandwidth Management": "Enabled",
        "Ethernet Auto Negotiation": "On",
        "Network Mask": "255.255.255.0",
        "Default Route": "192.168.1.1",
        "IPv6 Default Gateway": "fe80::1",
        "IPv4 Default Gateway": "192.168.1.1",
        # Additional settings (examples):
        "Proxy Server Enabled": "No",
        "Proxy Server Address": "",
        "Proxy Server Port": "",
        "VPN Protocol": "IKEv2",
        "VPN Server Address": "vpn.example.com",
        "VPN Connection Type": "Full Tunnel",
        "VPN Auto Reconnect": "Yes",
        "VPN Kill Switch": "Enabled",
        "Wi-Fi MAC Address": "00:1A:2B:3C:4D:5F",
        "Wi-Fi Channel": "6",
        "Wi-Fi Band": "2.4 GHz",
        "Ethernet Speed": "1 Gbps",
        "Ethernet Duplex": "Full",
        "Bluetooth Version": "5.0",
        "Bluetooth Pairing Mode": "Automatic",
        "Bluetooth Devices Paired": "Device1, Device2",
        "External USB Storage Devices": "3",
        "Connected Printers": "Printer1",
        "Connected External Monitors": "2",
        "Touch Screen Enabled": "Yes",
        "Pen Input Enabled": "Yes",
        "Camera Resolution": "1920x1080",
        "Microphone Array": "Enabled",
        "Speaker System": "Dolby Atmos",
        "Audio Output Mode": "Stereo",
        "Audio Input Mode": "Stereo Mix",
        "System Volume": "70%",
        "Notification Sound": "On",
        "Startup Programs": "Antivirus, Cloud Sync",
        "Auto Updates": "On",
        "Background Apps": "All Allowed",
        "Privacy Settings": "Standard",
        "Data Collection": "Enabled",
        "Telemetry Level": "Full",
        "Error Reporting": "On",
        "Diagnostic Data Sharing": "Full",
        "Automatic Backup": "On",
        "Cloud Sync Enabled": "Yes",
        "OneDrive Sync": "On",
        "Dropbox Sync": "Off",
        "Google Drive Sync": "On",
        "System Restore Point Frequency": "Daily",
        "Disk Cleanup Schedule": "Weekly",
        "Defragmentation Schedule": "Weekly",
        "Page File Size": "16 GB",
        "Virtual Memory Enabled": "Yes",
        "Windows Update Channel": "Semi-Annual Channel",
        "Windows Update Schedule": "Automatic",
        "Driver Updates": "Automatic",
        "Security Software": "Windows Defender",
        "Firewall Policy": "Default",
        "User Account Control": "Enabled",
        "BitLocker Encryption": "On",
        "Device Encryption": "On",
        "Device Drivers": "All Updated",
        "System Language": "English",
        "Keyboard Layout": "US",
        "Input Method": "US Keyboard",
        "Language Packs Installed": "English, Spanish",
        "Region": "United States",
        "Time Format": "24-hour",
        "Date Format": "MM/DD/YYYY",
        "Display Language": "English",
        "Screen Saver Timeout": "10 minutes",
        "Screen Timeout": "5 minutes",
        "Battery Optimization": "Maximum",
        "Power Settings": "High Performance",
        "Sleep Mode": "Enabled",
        "Hibernate Mode": "Enabled",
        "USB Charging During Sleep": "Enabled",
        "External Devices Power": "Maximum",
        "Device Sleep Mode": "Enabled",
        "Network Discovery": "On",
        "File Sharing": "On",
        "Printer Sharing": "On",
        "Media Streaming": "Allowed",
        "Remote Management": "Enabled",
        "Remote Desktop": "Enabled",
        "Remote Assistance": "On",
        "Remote Desktop Port": "3389",
        "VPN Kill Switch": "Enabled",
        "Firewall Exceptions": "None",
        "Network Profile": "Private",
        "Wi-Fi Auto Connect": "Yes",
        "Bluetooth Auto Connect": "Yes",
        "Wi-Fi Hotspot": "Off",
        "Network Statistics": "Active",
        "Data Usage Limit": "10 GB/month",
        "Bandwidth Usage": "Moderate",
        "Wi-Fi Signal Strength": "Strong",
        "Ethernet Link Speed": "1 Gbps",
        "VPN Connection": "Active",
        "Firewall Rules": "Default",
        "Network Security Level": "High",
        "Public IP Address": "203.0.113.45",
        "Private IP Address": "192.168.1.100",
        "IPv6 Address": "fe80::1a2b:3c4d:5e6f",
        "IPv4 Address": "192.168.1.100",
        "Wireless Network Name": "MyWiFi",
        "WPA2 Security": "Enabled",
        "WPA3 Security": "Off",
        "Guest Network": "Disabled",
        "Device Sleep": "Enabled",
        "Energy Saver Mode": "On",
        "Battery Charge Level": "85%",
        "Battery Cycle Count": "150",
        "System Temperature": "45°C",
        "GPU Temperature": "50°C",
        "CPU Temperature": "55°C",
        "Fan Speed": "Auto",
        "CPU Load": "20%",
        "Memory Usage": "30%",
        "Disk Usage": "40%",
        "Network Usage": "10 Mbps",
        "Wi-Fi Band": "5 GHz",
        "Ethernet Speed": "1 Gbps",
        "Bluetooth Power": "On",
        "Bluetooth Devices": "Headphones, Mouse",
        "External Speakers": "Connected",
        "Headphone Jack": "Active",
        "Microphone Input": "On",
        "Camera Brightness": "70%",
        "Camera Sharpness": "High",
        "Microphone Gain": "80%",
        "Speaker Volume": "70%",
        "System Volume": "70%",
        "Notification Settings": "All",
        "Focus Assist": "Off",
        "Night Light Schedule": "Sunset to Sunrise",
        "Brightness Level": "70%",
        "Color Calibration": "Default",
        "Display Timeout": "5 minutes",
        "Auto Lock": "Enabled",
        "Screen Resolution": "1920x1080",
        "Scaling": "100%",
        "Color Profile": "sRGB",
        "Wi-Fi Channel Width": "80 MHz",
        "Wi-Fi Bandwidth": "20/40/80 MHz",
        "Wi-Fi Roaming Sensitivity": "High",
        "Wi-Fi Auto-Reconnect": "Enabled",
        "Wi-Fi Power Save Mode": "Maximum",
        "Wi-Fi Network Priority": "High",
        "Wi-Fi Signal Noise Level": "-90 dBm",
        "Wi-Fi Signal Quality": "Excellent",
        "Wi-Fi Roaming Threshold": "70%",
        "Wi-Fi Protected Setup (WPS)": "Enabled"
    })
    if not settings:
        settings.update(default_settings)

    while True:
        print_border("Settings Menu")
        print("1. View All Settings")
        print("2. Search Settings")
        print("3. Make Changes to Settings")
        print("4. Return")
        choice = input("Choose (1-4): ").strip()

        if choice == '1':
            print_border("All Settings")
            for k, v in settings.items():
                print(f"{k}: {v}")
            pause()

        elif choice == '2':
            # Call the search function
            search_settings(users, username)

        elif choice == '3':
            # Make changes to settings
            print("\nSelect a setting to edit:")
            keys_list = list(settings.keys())
            for idx, k in enumerate(keys_list, 1):
                print(f"{idx}. {k}: {settings[k]}")
            sel = input("Enter number of setting to edit (or '0' to cancel): ").strip()
            if sel.isdigit():
                sel_idx = int(sel)
                if sel_idx == 0:
                    print("Cancelled.")
                elif 1 <= sel_idx <= len(keys_list):
                    key_to_edit = keys_list[sel_idx - 1]
                    current_value = settings[key_to_edit]
                    new_value = input(f"New value for '{key_to_edit}' (current: {current_value}): ").strip()
                    if new_value:
                        settings[key_to_edit] = new_value
                        save_users(users)
                        print(f"{key_to_edit} updated.")
                    else:
                        print("No change made.")
                else:
                    print("Invalid selection.")
            else:
                print("Invalid input.")
            pause()

        elif choice == '4':
            break

# Main loop
if __name__ == '__main__':
    users = load_users()
    current_username = None  # Track logged-in user
    while True:
        print_header()
        print("Main Menu")
        print("1. Register")
        print("2. Login")
        print("3. Exit")
        print("4. Settings")  # Optional: direct access if logged in
        choice = input("Select (1-4): ").strip()
        if choice == '1':
            users = register_user(users)
        elif choice == '2':
            login_user(users)
            # After login, set current_username
            # We'll modify login_user to return username
            # but for simplicity, assume login_user sets global or similar
            # Since your code doesn't do that, you can store it as:
            # For now, let's assume login_user updates a global variable
            # or you can modify login_user to return username.
            # Let's do a quick fix:
            def login_user_return():
                print_header()
                print("Login")
                username = input("Username: ").strip()
                password = getpass.getpass("Password (input hidden): ").strip()

                while True:
                    show_option = input("Would you like to view the entered password? (y/n): ").strip().lower()
                    if show_option == 'y':
                        print(f"Entered Password: {password}")
                        break
                    elif show_option == 'n':
                        break
                    else:
                        print("Please enter 'y' or 'n'.")

                if username in users and users[username]['password'] == password:
                    print(f"\nWelcome, {username}!")
                    pause()
                    return username
                else:
                    print("Invalid username or password.")
                    pause()
                    return None

            current_username = login_user_return()
        elif choice == '3':
            print("Goodbye!")
            break
        elif choice == '4':
            if current_username:
                # Direct access to settings
                settings_menu(users, current_username)
            else:
                print("Please login first.")
                pause()
        else:
            print("Invalid choice.")
            pause()
